/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.tables.block.ITabbedBlock;
import slimeknights.tconstruct.tables.client.inventory.module.SideInventoryScreen;
import slimeknights.tconstruct.tables.client.inventory.module.TinkerTabsScreen;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;
import slimeknights.tconstruct.tables.menu.module.SideInventoryContainer;
import slimeknights.tconstruct.tables.network.StationTabPacket;

public class BaseTabbedScreen<TILE extends BlockEntity, CONTAINER extends TabbedContainerMenu<TILE>>
extends MultiModuleScreen<CONTAINER> {
    protected static final Component COMPONENT_WARNING = TConstruct.makeTranslation("gui", "warning");
    protected static final Component COMPONENT_ERROR = TConstruct.makeTranslation("gui", "error");
    public static final ResourceLocation BLANK_BACK = TConstruct.getResource("textures/gui/blank.png");
    protected final TILE tile;
    protected final CONTAINER container;
    protected TinkerTabsScreen tabsScreen;

    public BaseTabbedScreen(CONTAINER container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tile = container.getTile();
        this.container = container;
        this.tabsScreen = new TinkerTabsScreen(this, (AbstractContainerMenu)container, playerInventory, title);
        this.addModule(this.tabsScreen);
        if (this.tile != null) {
            Level world = this.tile.m_58904_();
            if (world != null) {
                for (Pair<BlockPos, BlockState> pair : ((TabbedContainerMenu)((Object)container)).stationBlocks) {
                    BlockState state = (BlockState)pair.getRight();
                    BlockPos blockPos = (BlockPos)pair.getLeft();
                    ItemStack stack = state.m_60734_().getCloneItemStack(state, null, (BlockGetter)world, blockPos, playerInventory.f_35978_);
                    this.tabsScreen.addTab(stack, blockPos);
                }
            }
            for (int i = 0; i < this.tabsScreen.tabData.size(); ++i) {
                if (!this.tabsScreen.tabData.get(i).equals((Object)this.tile.m_58899_())) continue;
                this.tabsScreen.tabs.selected = i;
            }
        }
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    protected void drawIcon(PoseStack matrices, Slot slot, ElementScreen element) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)Icons.ICONS);
        element.draw(matrices, slot.f_40220_ + this.cornerX - 1, slot.f_40221_ + this.cornerY - 1);
    }

    protected void drawIconEmpty(PoseStack matrices, Slot slot, ElementScreen element) {
        if (slot.m_6657_()) {
            return;
        }
        this.drawIcon(matrices, slot, element);
    }

    public void onTabSelection(int selection) {
        if (selection < 0 || selection > this.tabsScreen.tabData.size()) {
            return;
        }
        Level world = this.tile.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = this.tabsScreen.tabData.get(selection);
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof ITabbedBlock) {
            TinkerNetwork.getInstance().sendToServer(new StationTabPacket(pos));
            assert (this.f_96541_ != null);
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    public void error(Component message) {
    }

    public void warning(Component message) {
    }

    public void updateDisplay() {
    }

    protected void addChestSideInventory(Inventory inventory) {
        SideInventoryContainer sideInventoryContainer = (SideInventoryContainer)this.container.getSubContainer(SideInventoryContainer.class);
        if (sideInventoryContainer != null) {
            Component sideInventoryName = TextComponent.f_131282_;
            BlockEntity te = sideInventoryContainer.getTile();
            if (te instanceof MenuProvider) {
                sideInventoryName = ((MenuProvider)te).m_5446_();
            }
            this.addModule(new SideInventoryScreen<BaseTabbedScreen, SideInventoryContainer>(this, sideInventoryContainer, inventory, sideInventoryName, sideInventoryContainer.getSlotCount(), sideInventoryContainer.getColumns()));
        }
    }
}

